const btn = document.getElementById("backToTop");
const searchInput = document.querySelector(".search-box input");
const comics = document.querySelectorAll(".comic-item");
document.addEventListener("DOMContentLoaded", () => {
    const header = document.querySelector(".header");

    if (!header) return;

    // Tạo container hoa nếu chưa có
    let container = header.querySelector(".sakura-container");
    if (!container) {
        container = document.createElement("div");
        container.className = "sakura-container";
        header.appendChild(container);
    }

    function createSakura() {
        const sakura = document.createElement("span");
        sakura.className = "sakura";
        sakura.textContent = "🌸";

        // Ngẫu nhiên
        sakura.style.left = Math.random() * 100 + "%";
        sakura.style.fontSize = 12 + Math.random() * 14 + "px";
        sakura.style.animationDuration = 5 + Math.random() * 6 + "s";
        sakura.style.opacity = Math.random() * 0.5 + 0.4;
        sakura.style.transform = `rotate(${Math.random() * 360}deg)`;

        container.appendChild(sakura);

        // Xóa sau khi rơi xong
        setTimeout(() => {
            sakura.remove();
        }, 12000);
    }

    // Tạo nhiều hoa liên tục
    setInterval(createSakura, 200);
});




window.addEventListener("scroll", () => {
    if (window.scrollY > 300) {
        btn.style.display = "block";
    } else {
        btn.style.display = "none";
    }
});

btn.addEventListener("click", () => {
    window.scrollTo({
        top: 0,
        behavior: "smooth"
    });
});


searchInput.addEventListener("input", () => {
    const keyword = searchInput.value.toLowerCase().trim();

    comics.forEach(item => {
        const title = item.querySelector("h3").innerText.toLowerCase();
        item.style.display = title.includes(keyword) ? "block" : "none";
    });
});

document.querySelectorAll(".comic-item").forEach(item => {
    item.addEventListener("click", () => {
        const comic = item.dataset.comic;
        window.location.href = `comic.html?name=${comic}`;
    });
});

